/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import filenet.vw.toolkit.runtime.property.images.VWImageLoader;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VWWorkflowGeneralPanel
extends JPanel {
    private Frame m_parentFrame = null;
    private VWTrkDataModel m_trackerDataModel = null;
    private boolean m_bCompleted = false;
    private JTextField m_originator = new JTextField();
    private JTextField m_launchDate = new JTextField();
    private JTextField m_rosterName = new JTextField();
    private JTextField m_eventLogName = new JTextField();
    private JTextField m_conditionIdentifier = new JTextField();
    private JLabel m_deadlineLabel = new JLabel(VWResource.s_label.toString(VWResource.s_deadline));
    private JLabel m_launchedLabel = new JLabel(VWResource.s_label.toString(VWResource.s_launched));
    private JPanel m_deadlinePanel = new JPanel();
    private JTextField m_deadline = new JTextField();
    private JLabel m_deadlineIcon = new JLabel();
    private JPanel m_statusPanel = new JPanel();
    private JTextField m_status = new JTextField();
    private JLabel m_statusIcon = new JLabel();
    private Date m_workflowDeadline = null;
    private DateFormat m_dateTimeFormatter = DateFormat.getDateTimeInstance(2, 2);

    public VWWorkflowGeneralPanel(Frame parentFrame, VWTrkDataModel dataModel) {
        this.m_parentFrame = parentFrame;
        this.m_trackerDataModel = dataModel;
        this.setupLayout();
        this.m_originator.setEditable(false);
        this.m_originator.setBorder(null);
        this.m_launchDate.setEditable(false);
        this.m_launchDate.setBorder(null);
        this.m_rosterName.setEditable(false);
        this.m_rosterName.setBorder(null);
        this.m_eventLogName.setEditable(false);
        this.m_eventLogName.setBorder(null);
        this.m_conditionIdentifier.setEditable(false);
        this.m_conditionIdentifier.setBorder(null);
        this.m_deadline.setEditable(false);
        this.m_deadline.setBorder(null);
        this.m_status.setEditable(false);
        this.m_status.setBorder(null);
    }

    public void initialize() {
        if (this.m_trackerDataModel.getInitState() == 6) {
            VWParticipantItem origItem = new VWParticipantItem(this.m_trackerDataModel.getOriginator());
            this.setTextField(this.m_originator, origItem.getDisplayName());
            Date launchDate = this.m_trackerDataModel.getLaunchDate();
            if (launchDate != null) {
                this.setTextField(this.m_launchDate, this.m_dateTimeFormatter.format(launchDate));
            }
            this.setTextField(this.m_rosterName, this.m_trackerDataModel.getRosterName());
            this.setTextField(this.m_eventLogName, this.m_trackerDataModel.getEventLogName());
            this.setTextField(this.m_conditionIdentifier, this.m_trackerDataModel.getTag());
            this.updateStatus();
        }
    }

    private void setupLayout() {
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 23;
        c.insets = new Insets(0, 4, 0, 4);
        statusPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_originator)), c);
        c.gridy = -1;
        statusPanel.add((Component)this.m_launchedLabel, c);
        statusPanel.add((Component)this.m_deadlineLabel, c);
        JLabel statusLabel = new JLabel(VWResource.s_label.toString(VWResource.s_status));
        statusPanel.add((Component)statusLabel, c);
        statusPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_roster)), c);
        statusPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_eventLog)), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        statusPanel.add((Component)this.m_originator, c);
        c.gridy = -1;
        statusPanel.add((Component)this.m_launchDate, c);
        this.m_deadlinePanel.setLayout(new BorderLayout());
        this.m_deadlinePanel.add((Component)this.m_deadlineIcon, "Before");
        this.m_deadlinePanel.add((Component)this.m_deadline, "Center");
        statusPanel.add((Component)this.m_deadlinePanel, c);
        this.m_statusPanel.setLayout(new BorderLayout());
        this.m_statusPanel.add((Component)this.m_statusIcon, "Before");
        this.m_statusPanel.add((Component)this.m_status, "Center");
        statusPanel.add((Component)this.m_statusPanel, c);
        statusPanel.add((Component)this.m_rosterName, c);
        statusPanel.add((Component)this.m_eventLogName, c);
        c.gridx = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.anchor = 23;
        c.insets = new Insets(0, 4, 0, 4);
        c.fill = 2;
        c.weightx = 1.0;
        JPanel panel = new JPanel(new BorderLayout(10, 0));
        panel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_conditionIdentifier)), "Before");
        panel.add((Component)this.m_conditionIdentifier, "Center");
        statusPanel.add((Component)panel, c);
        this.setLayout(new BorderLayout());
        this.add((Component)statusPanel, "First");
    }

    public void updateInfo() {
        this.updateStatus();
    }

    private void updateStatus() {
        boolean bDisplayDeadline = false;
        int overdue = 0;
        VWTrkStep step = null;
        Vector m_activeSteps = new Vector();
        m_activeSteps = this.m_trackerDataModel.getActiveSteps();
        if (m_activeSteps != null && m_activeSteps.size() > 0) {
            for (int i = 0; i < m_activeSteps.size(); ++i) {
                Vector occurrences;
                step = (VWTrkStep)m_activeSteps.elementAt(i);
                if (step == null) continue;
                int status = step.getStatus();
                if (status == 1 && (occurrences = step.getActiveOccurrences()) != null && occurrences.size() > 0) {
                    block12: for (int index = 0; index < occurrences.size(); ++index) {
                        VWTrkStepOccurrence occurrence = (VWTrkStepOccurrence)occurrences.elementAt(index);
                        Vector participants = occurrence.getActiveParticipants();
                        if (participants == null) continue;
                        for (int j = 0; j < participants.size(); ++j) {
                            VWTrkParticipant participant;
                            Object obj = participants.elementAt(j);
                            if (obj == null || !(obj instanceof VWTrkParticipant) || !(participant = (VWTrkParticipant)obj).isActive()) continue;
                            VWTrkWorkObject trkWorkObject = participant.getParticipantWorkObject();
                            VWWorkObject vwWorkObject = trkWorkObject.getVWWorkObject();
                            try {
                                String exceptionStr = vwWorkObject.getLastErrorNumber();
                                if (exceptionStr == null || VWStringUtils.compare(exceptionStr, "0") == 0) continue;
                                status = 12;
                                continue block12;
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                            }
                        }
                    }
                }
                if (status != 12) continue;
                this.m_statusIcon.setIcon(VWImageLoader.createImageIcon("error.gif"));
                this.m_status.setText(VWResource.s_exception);
                return;
            }
        } else {
            Vector maps = this.m_trackerDataModel.getMaps();
            if (maps != null) {
                for (int i = 0; i < maps.size(); ++i) {
                    VWTrkMap map;
                    Object obj = maps.elementAt(i);
                    if (obj == null || !(obj instanceof VWTrkMap) || (map = (VWTrkMap)obj) == null) continue;
                    Vector steps = map.getSteps();
                    for (int j = 0; j < steps.size(); ++j) {
                        int status;
                        obj = steps.elementAt(j);
                        if (obj == null || !(obj instanceof VWTrkStep) || (status = (step = (VWTrkStep)obj).getStatus()) != 12) continue;
                        this.m_statusIcon.setIcon(VWImageLoader.createImageIcon("error.gif"));
                        this.m_status.setText(VWResource.s_exception);
                        return;
                    }
                }
            }
        }
        try {
            overdue = this.m_trackerDataModel.getWorkflowOverdue();
        }
        catch (VWException ex) {
            // empty catch block
        }
        switch (overdue) {
            default: {
                this.m_deadlineIcon.setIcon(null);
                bDisplayDeadline = true;
                try {
                    this.m_workflowDeadline = this.m_trackerDataModel.getWorkflowDeadline();
                }
                catch (VWException ex) {
                    this.m_workflowDeadline = null;
                }
                if (this.m_workflowDeadline != null) {
                    this.m_deadline.setText(this.m_dateTimeFormatter.format(this.m_workflowDeadline));
                } else {
                    this.m_deadline.setText(VWResource.s_none);
                }
                this.m_statusIcon.setIcon(VWImageLoader.createImageIcon("inprogress.gif"));
                this.m_status.setText(VWResource.s_inProgress);
                break;
            }
            case 1: {
                this.m_statusIcon.setIcon(VWImageLoader.createImageIcon("reminder.gif"));
                this.m_status.setText(VWResource.s_reminded);
                break;
            }
            case 2: {
                this.m_statusIcon.setIcon(VWImageLoader.createImageIcon("overdue.gif"));
                this.m_status.setText(VWResource.s_overdue);
                break;
            }
            case 3: {
                this.m_statusIcon.setIcon(VWImageLoader.createImageIcon("completed_green.gif"));
                Date date = this.m_trackerDataModel.getWorkflowCompletionDate();
                if (date != null) {
                    this.m_status.setText(this.m_dateTimeFormatter.format(date));
                    break;
                }
                this.m_status.setText(VWResource.s_completed);
            }
        }
        this.m_deadlineLabel.setVisible(bDisplayDeadline);
        this.m_deadlinePanel.setVisible(bDisplayDeadline);
    }

    private void setTextField(JTextField field, String text) {
        if (text == null) {
            field.setText(VWResource.s_none);
        } else {
            field.setText(text);
            field.setToolTipText(VWStringUtils.formatToolTip(text, 0));
        }
    }

    private void logShowException(Exception ex, String title) {
        VWDebug.logException(ex);
        String msg = ex.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = ex.getClass().getName();
        }
        JOptionPane.showMessageDialog(this.m_parentFrame, msg, title, 0, null);
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_trackerDataModel = null;
        this.m_originator = null;
        this.m_launchDate = null;
        this.m_rosterName = null;
        this.m_eventLogName = null;
        this.m_conditionIdentifier = null;
        this.m_deadlineLabel = null;
        this.m_launchedLabel = null;
        if (this.m_deadlinePanel != null) {
            this.m_deadlinePanel.setLayout(null);
            this.m_deadlinePanel.removeAll();
            this.m_deadlinePanel = null;
        }
        this.m_deadline = null;
        this.m_deadlineIcon = null;
        if (this.m_statusPanel != null) {
            this.m_statusPanel.setLayout(null);
            this.m_statusPanel.removeAll();
            this.m_statusPanel = null;
        }
        this.m_status = null;
        this.m_statusIcon = null;
        this.m_workflowDeadline = null;
    }
}

